<?php
session_start();
include 'config.php';

$sql = "SELECT files.id, files.filename, users.username, files.upload_date
        FROM files
        JOIN users ON files.uploaded_by = users.id";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yüklenen Dosyalar</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            max-width: 800px;
            width: 100%;
        }
        .container h2 {
            margin-top: 0;
            text-align: center;
        }
        .container table {
            width: 100%;
            border-collapse: collapse;
        }
        .container table th, .container table td {
            padding: 10px;
            border: 1px solid #ced4da;
        }
        .container table th {
            background: #f1f1f1;
        }
        .container a {
            display: block;
            margin-top: 10px;
            text-align: center;
            color: #007bff;
            text-decoration: none;
        }
        .container a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Yüklenen Dosyalar</h2>
        <table>
            <tr>
                <th>Dosya Adı</th>
                <th>Yükleyen</th>
                <th>Yükleme Tarihi</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['filename']); ?></td>
                <td><?php echo htmlspecialchars($row['username']); ?></td>
                <td><?php echo htmlspecialchars($row['upload_date']); ?></td>
            </tr>
            <?php endwhile; ?>
        </table>
        <a href="index.php">Ana Sayfaya Dön</a>
    </div>
</body>
</html>
