<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: index.php");
    exit();
}

// Dosya silme
if (isset($_GET['delete_file'])) {
    $file_id = intval($_GET['delete_file']);
    $stmt = $conn->prepare("SELECT filename FROM files WHERE id = ?");
    $stmt->bind_param("i", $file_id);
    $stmt->execute();
    $stmt->bind_result($filename);
    $stmt->fetch();
    $stmt->close();

    if ($filename) {
        if (file_exists("uploads/$filename")) {
            unlink("uploads/$filename");
        }

        $stmt = $conn->prepare("DELETE FROM files WHERE id = ?");
        $stmt->bind_param("i", $file_id);
        $stmt->execute();
        $stmt->close();
    }
}

// Dosya adı düzenleme
if (isset($_POST['edit_file'])) {
    $file_id = intval($_POST['file_id']);
    $new_name = $_POST['new_name'];

    $stmt = $conn->prepare("UPDATE files SET filename = ? WHERE id = ?");
    $stmt->bind_param("si", $new_name, $file_id);
    $stmt->execute();
    $stmt->close();
}

// Kullanıcı ekleme
if (isset($_POST['add_user'])) {
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $email = $_POST['email'];
    $role = $_POST['role'];

    $stmt = $conn->prepare("INSERT INTO users (username, password, email, role) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $username, $password, $email, $role);
    $stmt->execute();
    $stmt->close();
}

// Ana sayfa içeriğini güncelleme
if (isset($_POST['update_homepage'])) {
    $homepage_content = $_POST['homepage_content'];

    $stmt = $conn->prepare("REPLACE INTO settings (key, value) VALUES ('homepage_content', ?)");
    $stmt->bind_param("s", $homepage_content);
    $stmt->execute();
    $stmt->close();
}

// Kullanıcılar ve dosyalar
$sql_users = "SELECT id, username, email, role FROM users";
$result_users = $conn->query($sql_users);

$sql_files = "SELECT id, filename FROM files";
$result_files = $conn->query($sql_files);

$sql_settings = "SELECT value FROM settings WHERE `key` = 'homepage_content'";
$result_settings = $conn->query($sql_settings);
$homepage_content = $result_settings->fetch_assoc()['value'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yönetim Paneli</title>
</head>
<body>
    <h2>Yönetim Paneli</h2>

    <h3>Kullanıcı Ekle</h3>
    <form action="admin.php" method="post">
        Kullanıcı Adı: <input type="text" name="username" required><br>
        Şifre: <input type="password" name="password" required><br>
        E-posta: <input type="email" name="email" required><br>
        Rol: 
        <select name="role">
            <option value="user">Kullanıcı</option>
            <option value="admin">Yönetici</option>
        </select><br>
        <input type="submit" value="Kullanıcı Ekle" name="add_user">
    </form>

    <h3>Dosya Listesi</h3>
    <table>
        <tr>
            <th>ID</th>
            <th>Dosya Adı</th>
            <th>Sil</th>
            <th>Düzenle</th>
        </tr>
        <?php while ($row = $result_files->fetch_assoc()): ?>
        <tr>
            <td><?php echo htmlspecialchars($row['id']); ?></td>
            <td><?php echo htmlspecialchars($row['filename']); ?></td>
            <td><a href="admin.php?delete_file=<?php echo htmlspecialchars($row['id']); ?>">Sil</a></td>
            <td>
                <form action="admin.php" method="post">
                    <input type="hidden" name="file_id" value="<?php echo htmlspecialchars($row['id']); ?>">
                    <input type="text" name="new_name" value="<?php echo htmlspecialchars($row['filename']); ?>" required>
                    <input type="submit" value="Düzenle" name="edit_file">
                </form>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>

    <h3>Ana Sayfa İçeriğini Güncelle</h3>
    <form action="admin.php" method="post">
        <textarea name="homepage_content" rows="4" cols="50" required><?php echo htmlspecialchars($homepage_content); ?></textarea><br>
        <input type="submit" value="Güncelle" name="update_homepage">
    </form>

    <h3>Kullanıcı Listesi</h3>
    <table>
        <tr>
            <th>ID</th>
            <th>Kullanıcı Adı</th>
            <th>E-posta</th>
            <th>Rol</th>
        </tr>
        <?php while ($row = $result_users->fetch_assoc()): ?>
        <tr>
            <td><?php echo htmlspecialchars($row['id']); ?></td>
            <td><?php echo htmlspecialchars($row['username']); ?></td>
            <td><?php echo htmlspecialchars($row['email']); ?></td>
            <td><?php echo htmlspecialchars($row['role']); ?></td>
        </tr>
        <?php endwhile; ?>
    </table>

    <a href="logout.php">Çıkış Yap</a>
</body>
</html>
